﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.BusinessManager;

public partial class LabKitOrders : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
    }


    protected void ButtonOK_Click(object sender, EventArgs e)
    {
        GridLabKitOrders.PageIndex = 0;
    }

    protected void SelectPatients(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Details")
        {
            int index = Convert.ToInt32(e.CommandArgument);
            GridLabKitOrders.SelectedIndex = index;
            Int32 InstitutionId = Convert.ToInt32(GridLabKitOrders.SelectedDataKey.Values[0]);
            int KitTypeId = Convert.ToInt16(GridLabKitOrders.SelectedDataKey.Values[1]);
            Response.Redirect(string.Format("LabKitOrder.aspx?InstitutionId={0}&KitTypeId={1}", InstitutionId,KitTypeId));
        }
    }

    protected void ChangeGroupingText(object sender, RepeaterItemEventArgs e)
    {
        Panel PanelPat = (Panel)e.Item.FindControl("PanelPatient");

        if (PanelPat != null)
                PanelPat.GroupingText = "Patients requiring kits";
    }
    protected void ChangeEmptyDataText(object sender, ObjectDataSourceStatusEventArgs e)
    {
        if (!e.ReturnValue.GetType().IsValueType)
        if (e.ReturnValue != null)
        {
            int RetCount = ((List<LabKitOrderGroup>)e.ReturnValue).Count;
            if (RetCount == 0)
                GridLabKitOrders.EmptyDataText = "No patients found for new kit orders.";
        }
    }


    protected void buttonPrint_Click(object sender, EventArgs e)
    {
        Response.Redirect("LabKitsReport.aspx");
    }


    public override string TopMenuName()
    {
        return "My Tasks";
    }

    public override string MenuItemName()
    {
        return "LabKitOrders";
    }

    public override string AppObjectCode()
    {
        return "LabKitOrders";
    }
    protected void ButtonClear_Click(object sender, EventArgs e)
    {
        ButtonOK_Click(sender, e);
    }
}
